#include <bits/stdc++.h>
using namespace std;

#define int long long
const int N=2e5+4;
int a[N],b[N],dp[32][2],n;
bool tr[N],cpy[N],vv[32][2][N];

struct trienode{
    int val;
    trienode *deca[2];
};

trienode *make(){
    trienode *cur=new trienode;
    cur->val=0;
    cur->deca[0]=NULL;
    cur->deca[1]=NULL;
    return cur;
}

void insert(trienode*root,int x){
    trienode *cur=root;
    for(int i=31;i>=0;--i){
        bool b=x&(1<<i);
        if(cur->deca[b]==NULL)
            cur->deca[b]=make();
        cur=cur->deca[b];
    }
    cur->val=x;
}

int qry(trienode*root,int x){
    trienode *cur=root;
    for(int i=31;i>=0;--i){
        bool b=x&(1<<i);
        if(cur->deca[!b]!=NULL)
            cur=cur->deca[!b];
        else if(cur->deca[b]!=NULL)
            cur=cur->deca[b];
    }
    return x^(cur->val);
}

void resettrie(trienode*root){
    if(root==NULL)
        return;
    resettrie(root->deca[0]);
    resettrie(root->deca[1]);
    delete root;
}

int get(int l,int r){
    if(l>r)return 0;
    trienode*root=make();
    resettrie(root);
    root=make();
    insert(root,(l?a[l-1]:0ll));
    int res=0;
    for(int i=l;i<=r;++i){
        res=max(res,qry(root,a[i]));
        insert(root,a[i]);
    }
    return res;
}

int brute(){
    int ans=0;
    for(int l=0;l<n;++l){
        int c1=0,c2=b[l];
        for(int r=l;r>=0;--r){
            c1^=a[r];
            c2&=b[r];
            ans=max(ans,c1*c2);
        }
    }
    return ans;
}

int calc(){
    int len=0,res=0;
    for(int i=0;i<n;++i){
        if(!tr[i]){
            res=max(res,get(i-len,i-1));
            len=0;
        }else
            ++len;
    }
    return max(res,get(n-len,n-1));
}

int sfb(){
    for(int i=0;i<n;++i)
        tr[i]=(b[i]&1);
    int ans=calc();
    for(int i=0;i<n;++i)
        tr[i]=(b[i]&2);
    ans=max(ans,calc()*2);
    for(int i=0;i<n;++i)
        tr[i]=(b[i]==3);
    ans=max(ans,calc()*3);
    return ans;
}

signed main(){
    ios::sync_with_stdio(0);
    cin.tie(0);
    
    cin>>n;
    for(int i=0;i<n;++i)
        cin>>a[i];
    for(int i=0;i<n;++i)
        cin>>b[i];

    if(n<=2000){
        cout<<brute();
        return 0;
    }

    bool ai=1;
    for(int i=0;i<n;++i)
        ai&=(a[i]==1);

    if(ai){
        cout<<*max_element(b,b+n);
        return 0;
    }

    for(int i=1;i<n;++i)
        a[i]^=a[i-1];

    bool bm=1;
    for(int i=0;i<n;++i)
        bm&=(b[i]<=3);

    if(bm){
        cout<<sfb();
        return 0;
    }

    for(int i=30;i>=0;--i){
        bool ok=0;
        for(int k=0;k<n;++k)
            ok|=((b[k]&(1ll<<i))!=0);
        for(int k=0;k<n&&!ok;++k)
            vv[i][0][k]=vv[i][1][k]=1;
        dp[0][0]=dp[i][1]=0;
        if(!ok)
            continue;
        for(int k=0;k<n;++k){
            vv[i][0][k]=1;
            vv[i][1][k]=((b[k]&(1ll<<i))!=0);
        }
        dp[i][0]=0;
        dp[i][1]=(1ll<<i);
        break;
    }

    int ans=0;
    for(int i=30;i>=0;--i){
        int mx=0,mx2=0;
        for(int j=i+1;j<=30;++j){
            for(int k=0;k<n;++k)
                tr[k]=(vv[j][0][k])&((b[k]&(1ll<<i))!=0);
            int kk=dp[j][0]+(1ll<<i),cc=calc();
            if(kk*cc>mx){
                mx=kk*cc;
                dp[i][1]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][1][ii]=tr[ii];
            }else if(kk*cc==mx&&accumulate(vv[i][1],vv[i][1]+n,0ll)<accumulate(tr,tr+n,0ll)){
                mx=kk*cc;
                dp[i][1]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][1][ii]=tr[ii];
            }
            for(int k=0;k<n;++k)
                tr[k]=(vv[j][1][k])&((b[k]&(1ll<<i))!=0);
            kk=dp[j][1]+(1ll<<i),cc=calc();
            if(kk*cc>mx){
                mx=kk*cc;
                dp[i][1]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][1][i]=tr[ii];
            }else if(kk*cc==mx&&accumulate(vv[i][1],vv[i][1]+n,0ll)<accumulate(tr,tr+n,0ll)){
                mx=kk*cc;
                dp[i][1]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][1][ii]=tr[ii];
            }
            for(int k=0;k<n;++k)
                tr[k]=(vv[j][1][k]);
            kk=dp[j][1],cc=calc();
            if(kk*cc>mx2){
                mx=kk*cc;
                dp[i][0]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][0][ii]=tr[ii];
            }else if(dp[j][1]&&kk*cc==mx&&accumulate(vv[i][0],vv[i][0]+n,0ll)<accumulate(tr,tr+n,0ll)){
                mx2=kk*cc;
                dp[i][0]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][0][ii]=tr[ii];
            }
            for(int k=0;k<n;++k)
                tr[k]=(vv[j][0][k]);
            kk=dp[j][0],cc=calc();
            if(kk*cc>mx2){
                mx=kk*cc;
                dp[i][0]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][0][ii]=tr[ii];
            }else if(dp[j][0]&&kk*cc==mx&&accumulate(vv[i][0],vv[i][0]+n,0ll)<accumulate(tr,tr+n,0ll)){
                mx2=kk*cc;
                dp[i][0]=kk;
                for(int ii=0;ii<n;++ii)
                    vv[i][0][ii]=tr[ii];
            }
        }
        ans=max(ans,max(mx,mx2));
    }

    int cc1=dp[0][0];
    for(int i=0;i<n;++i)
        tr[i]=vv[0][0][i];
    cc1*=calc();
    int cc2=dp[0][1];
    for(int i=0;i<n;++i)
        tr[i]=vv[0][1][i];
    cc2*=calc();

    cout<<max(ans,max(cc1,cc2));
}